<?php
session_start();
require_once __DIR__.'/config.php';

// Sin login mientras SKIP_AUTH sea true (no te manda a index.php)
if (empty($_SESSION['autenticado']) && !SKIP_AUTH) {
  // header('Location: index.php'); exit();
}

function h($s){ return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

// Días y secciones (ajústalas a tu operación real)
$days = ["Lunes","Martes","Miércoles","Jueves","Viernes","Sábado"];
$sections = [
  "General Cleaning – Lobby, Offices, Hallways, Conference Room" => [
    "Clean glass entrance and employee entrance doors of fingerprints and smudges",
    "Spot clean interior glass",
    "Dust horizontal surfaces (counters, file cabinet tops)",
    "Spot clean horizontal surfaces to remove spots and spills",
    "Clean and disinfect drinking/water fountains",
    "Clean and disinfect light switches, switch plates, and door handles",
    "Clean doors of fingerprints and smudges",
    "Empty all wastepaper receptacles and replace liners",
    "Vacuum and wipe down furniture (fabric and hard surfaces)",
    "High dusting (air vents, tops of doors, frames, ceiling corners, blinds)",
    "Low dusting (front/sides of desks, chair/table legs, bases)",
  ],
  "Floor Care – Tile, Sealed Concrete" => [
    "Vacuum, sweep or dust mop all hard surface floors",
    "Vacuum all carpeted areas",
    "Vacuum walk-off mats inside office area",
    "Thoroughly mop all hard surface floors",
    "Remove spots and small spills from carpet",
    "Vacuum, sweep or dust mop Front Bay Area",
    "Mop Front Bay Area",
    "Sweep or dust mop Back Bay Area",
    "Dust and wipe down baseboards",
  ],
  "Restroom Cleaning" => [
    "Clean countertops, washbasins, toilets, toilet seats and urinals",
    "Wipe down all dispensers, fixtures and mirrors",
    "Empty trash receptacles and replace liners",
    "Empty sanitary napkin receptacle and disinfect",
    "Spot clean partitions and tile walls around toilets and urinals",
    "Clean partitions and tile walls around toilets and urinals",
    "Restock hand soap, paper products, and soap from customer stock",
    "Clean and disinfect partition handles, door handles and light switches",
    "Clean outsides of trash receptacles",
    "Sweep and thoroughly mop the floor with germicidal solution",
    "High dusting – tops of partitions, air vents, mirror frames and tops of doors",
  ],
  "Break Areas – Breakroom / Kitchen" => [
    "Clean and disinfect counters and tabletops",
    "Spot check fronts of counters and clean",
    "Clean sinks and drains",
    "Clean and disinfect light switches, plate covers, and door handles",
    "Clean outside of refrigerators, microwaves, and other small appliances",
    "Clean inside of microwave & refrigerator",
    "Empty receptacles and replace liners",
    "Replenish soap, paper towels, etc. with customer stock as needed",
    "Low dusting – table bases and chair legs",
  ],
];

// Flash message
$flash = $_SESSION['flash'] ?? null;
unset($_SESSION['flash']);

$today = date('Y-m-d');
?>
<!doctype html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Cleaning Schedule — Checklist</title>
<link rel="stylesheet" href="assets/style.css">
</head>
<body>

<?php if ($flash): ?>
  <div class="alert <?= $flash['type']==='ok' ? 'ok' : 'err' ?>">
    <?= h($flash['text']) ?>
  </div>
<?php endif; ?>

<div class="wrap">
  <form method="post" action="send.php" class="card">
    <div class="card__head">
      <img class="logo" src="https://thefreakyclean.com/wp-content/uploads/2024/04/Cleaning-Services-Charlotte-NC.png" alt="Logo">
      <h1>Cleaning Schedule — Checklist</h1>
      <p style="margin:6px 0 0 0;opacity:.95">Se enviará por correo a <?=h(TO_EMAIL)?></p>
    </div>

    <div style="padding:16px 16px 0">
      <div class="meta">
        <input type="text" name="client" placeholder="Client">
        <input type="text" name="by" placeholder="By">
        <input type="text" name="name" placeholder="Name">
        <input type="text" name="title" placeholder="Title">
        <input type="date" name="date" value="<?=h($today)?>">
      </div>
      <!-- Correo destino oculto -->
      <input type="hidden" name="to" value="<?=h(TO_EMAIL)?>">
    </div>

    <div style="padding:0 16px 16px">
      <table class="table">
        <thead>
          <tr>
            <th style="text-align:left">Task</th>
            <?php foreach($days as $d): ?>
              <th><?=h($d)?></th>
            <?php endforeach; ?>
          </tr>
        </thead>
        <tbody>
          <?php $sec=0; foreach ($sections as $sectionTitle => $tasks): ?>
            <!-- Enviar también el nombre real de la sección -->
            <input type="hidden" name="section_names[<?=$sec?>]" value="<?=h($sectionTitle)?>">
            <tr><td class="sec-head" colspan="<?=count($days)+1?>"><?=h($sectionTitle)?></td></tr>

            <?php $t=0; foreach ($tasks as $task): ?>
              <!-- Enviar también el nombre real de la tarea -->
              <input type="hidden" name="task_names[<?=$sec?>][<?=$t?>]" value="<?=h($task)?>">
              <tr>
                <td><?=h($task)?></td>
                <?php for ($i=0;$i<count($days);$i++): ?>
                  <td style="text-align:center">
                    <input type="checkbox" name="tasks[<?=$sec?>][<?=$t?>][<?=$i?>]" value="1">
                  </td>
                <?php endfor; ?>
              </tr>
            <?php $t++; endforeach; ?>
          <?php $sec++; endforeach; ?>
        </tbody>
      </table>

      <div class="submit">
        <button type="submit">Enviar checklist por correo</button>
      </div>
    </div>
  </form>
</div>

</body>
</html>
